/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portal.ui.dispatch.actionControllers;

import com.aptana.configurations.processor.ConfigurationStatus;
import com.aptana.core.logging.IdeLog;
import com.aptana.portal.ui.PortalUIPlugin;
import com.aptana.portal.ui.dispatch.BrowserNotifier;
import com.aptana.portal.ui.dispatch.IBrowserNotificationConstants;
import com.aptana.portal.ui.dispatch.actionControllers.AbstractActionController;
import com.aptana.portal.ui.dispatch.actionControllers.ControllerAction;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandHandlerActionController
extends AbstractActionController {
    private static final String JSON_WRAPPER = "\"{0}\"";
    private static final String NULL_JSON = "\"null\"";

    @ControllerAction
    public Object execute(Object attributes) {
        String commandId = this.getCommandId(attributes);
        if (commandId == null) {
            return IBrowserNotificationConstants.JSON_ERROR;
        }
        Map arguments = this.getCommandArguments(attributes);
        try {
            String eventCallback;
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            Command command = commandService.getCommand(commandId);
            if (command == null) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.portal.ui", "Command not found - " + commandId));
            }
            Object result = null;
            if (arguments == null) {
                ExecutionEvent event = new ExecutionEvent(command, Collections.emptyMap(), null, (Object)handlerService.getCurrentState());
                result = command.executeWithChecks(event);
            } else {
                ParameterizedCommand pc = ParameterizedCommand.generateCommand((Command)command, (Map)arguments);
                result = handlerService.executeCommand(pc, null);
            }
            if (result != null && (eventCallback = this.getEventCallbackName(attributes)) != null) {
                List<String> emptyList = Collections.emptyList();
                BrowserNotifier.getInstance().notifyBrowserInUIThread(emptyList, eventCallback, "changed", this.getJSONResult(result));
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)e);
            return IBrowserNotificationConstants.JSON_ERROR;
        }
        return IBrowserNotificationConstants.JSON_OK;
    }

    private String getCommandId(Object attributes) {
        if (attributes instanceof Object[]) {
            Object[] arr = (Object[])attributes;
            if (arr.length >= 1 && arr.length <= 3 && arr[0] != null) {
                return arr[0].toString();
            }
            String message = "Wrong argument count passed to CommandHandlerActionController::execute. Expected 1 or 2 and got " + arr.length;
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception(message));
        } else {
            String message = "Wrong argument type passed to CommandHandlerActionController::execute. Expected Object[] and got " + (attributes == null ? "null" : attributes.getClass().getName());
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception(message));
        }
        return null;
    }

    private Map getCommandArguments(Object attributes) {
        Object[] arr = (Object[])attributes;
        if (arr.length == 2 || arr.length == 3) {
            if (arr[1] instanceof Map) {
                return (Map)arr[1];
            }
            String message = "Wrong argument type passed as command-arguments to CommandHandlerActionController::execute. Expected 'Map' and got " + arr[1].getClass().getName();
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception(message));
        }
        return null;
    }

    private String getEventCallbackName(Object attributes) {
        Object[] arr = (Object[])attributes;
        if (arr.length == 3 && arr[2] != null) {
            return (String)arr[2];
        }
        return null;
    }

    private String getJSONResult(Object result) {
        if (result == null) {
            return NULL_JSON;
        }
        if (result instanceof IResource) {
            return MessageFormat.format(JSON_WRAPPER, ((IResource)result).getName());
        }
        return MessageFormat.format(JSON_WRAPPER, result.toString());
    }

    public void configurationStateChanged(ConfigurationStatus status, Set<String> attributesChanged) {
    }
}

